boolean findIntersect(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int n, boolean draw) {
  intersect = false;
  a1 = y2 - y1;
  b1 = x1 - x2;
  c1 = a1*x1 + b1*y1;
  a2 = y4 - y3;
  b2 = x3 - x4;
  c2 = a2*x3 + b2*y3;
  det = a1*b2 - a2*b1;
  if (det == 0) {
    // Lines are parallel
  } else {
    x = (b2*c1 - b1*c2)/det;  // set global variables intersection point x coordinate
    y = (a1*c2 - a2*c1)/det;  // set global variables intersection point y coordinate

    if (x > min(x1, x2) && x < max(x1, x2) &&
      x > min(x3, x4) && x < max(x3, x4) &&
      y > min(y1, y2) && y < max(y1, y2) &&
      y > min(y3, y4) && y < max(y3, y4)) {
      intersect = true;
    }
  }

  // if true then trace intersecting lines in blue
  if (draw == true) {
    strokeWeight(2);
    stroke(0, 0, 255); // blue
    line(x1, y1, x2, y2);
    line(x3, y3, x4, y4);
    ellipse(x, y, 10, 10);
  }

  xDesign[n] = x;  // set the global varables
  yDesign[n] = y;  // set the global varables
  stroke(255, 0, 0);  // set the design colour to red
  strokeWeight(4); // set the design weight
  return intersect; // retun true if the line interesetc
}
