// Mamluk Koran Page 88 - 98 of Islamic Geometric Patters
// Thames & Hudson by Eric Broug
// ISBN 978-0-500-28721-7
// ISBN 10: 050028721XISBN 13: 9780500287217
// code by Rupert Russell February 7th - 13th 2022 v012

// reference sites
// https://x-engineer.org/linear-interpolation-extrapolation-calculator/#formula

// code on github at: https://github.com/rupertrussell/mamluk_quran

// todo  refactor myLine to take parameters and save the coordinates of an intercetion point of 2 lines

float scale = 800;
int counter = 0;

float raduis = 0; // holds radius of inner circle calculated in  step 5
float[] xOuterCircle = new float[13]; // store points on outer circle
float[] yOuterCircle = new float[13]; // store points on outer circle

float[] xInnerCircle = new float[13]; // store points on outer circle
float[] yInnerCircle = new float[13]; // store points on outer circle

float[] xOuterSquare = new float[54]; // store points on outer square
float[] yOuterSquare = new float[54]; // store points on outer square

float[] xDesign = new float[99]; // store for points of final design
float[] yDesign = new float[99]; // store for points of final design


float xCenter = scale / 2;
float yCenter = scale / 2;
float extraoplatedY = 0;
float m = 0; // used to calculate extrapolation points
float y3 = 0;

// used in intersection testing
boolean intersect = false;
float x, y; // used to hold intersection point
float a1;
float b1;
float c1;
float a2;
float b2;
float c2;
float det;

int xOffset = 7; // text offset for point lables
int yOffset = 16; // text offset for point lables

void setup() {
  // size(scale,scale)
  size(900, 900);
  background(255);
  xOuterSquare[0] = scale;
  yOuterSquare[0] = scale/2;

  noLoop();
}

void draw() {
  translate(25, 25);

  strokeWeight(1);
  step1(); // outer rectangle, outer circle & six intersecting lines
  step2();
  step3();
  step4();
  myLine();
  step5();
  step6();
  step9();
  step11();
  step13();  // find intersection
  step15();
  step16();
  
  
  points(); // number points on OuterSquare
  desingPoints();  // number design points
  
  save("047.png");
}

float extrapolateY(float x1, float y1, float x2, float y2, float x) {
  m = (y2 - y1) / (x2 - x1);
  return y1 + m * (x - x1);
}


float extrapolateX(float x1, float y1, float x2, float y2, float y) {
  m = (y2 - y1) / (x2 - x1);
  return x1 + ((y - y1) * (x2 - x1)) / (y2 - y1);
}
