// Qarawiyyn Mosque Pages 104 - 115 of Islamic Geometric Patters
// Thames & Hudson by Eric Broug
// ISBN 978-0-500-28721-7
// ISBN 10: 050028721XISBN 13: 9780500287217
// code by Rupert Russell February 27 Feb 2022 v014

// reference sites
// https://x-engineer.org/linear-interpolation-extrapolation-calculator/#formula
// https://rosettacode.org/wiki/Line_circle_intersection
// Thanks to REAS for line circle intesection code
// https://openprocessing.org/sketch/8009#
// by https://openprocessing.org/user/54?view=sketches
// code on github at: https://github.com/rupertrussell/QarawiyynMosque

float weight = 2.5;  // StrokeWeight of design lines
boolean intersect = true;
boolean guides = true;  // I don't think this is used???
int testEllipseSize = 10;

float scale = 600;
int counter = 0;
int designWeight = 3;
int guideWeight = 1;

int srrr = 255;  // red value of design Stroke
int sggg = 0;  // green value of design Stroke
int sbbb = 0;  // blue value of design Stroke

int grrr = 0;  // red value of design Stroke
int gggg = 0;  // green value of design Stroke
int gbbb = 0;  // blue value of design Stroke

float[] xOuterCircle = new float[25]; // store points on outer circle
float[] yOuterCircle = new float[25]; // store points on outer circle

float[] xSquaresToOuterCircle = new float[49]; // store points on outer circle from extended square lines used in step 08
float[] ySquaresToOuterCircle = new float[49]; // store points on outer circle from extended square lines used in step 08

float[] xLinesToOuterCircle = new float[90]; // store points on outer circle from extended parallel lines used in step 09
float[] yLinesToOuterCircle = new float[90]; // store points on outer circle from extended parallel lines used in step 09

float innerRaduis = 0; // radius of inner circle calculated in  step06
float[] xInnerCircle = new float[13]; // store points on inner circle
float[] yInnerCircle = new float[13]; // store points on inner circle

float innerMostRaduis = 0; // radius of inner circle calculated in  step07
float[] xInnerMostCircle = new float[13]; // store points on innter most circle
float[] yInnerMostCircle = new float[13]; // store points on innter most circle

float[] xOuterHexagon = new float[25]; // store points on outer hexagon in step08
float[] yOuterHexagon = new float[25]; // store points on outer hexagon in step08

float[] xDesign = new float[99]; // store for points of final design
float[] yDesign = new float[99]; // store for points of final design

float[] xTemp = new float[99]; // Used for testing
float[] yTemp = new float[99]; // Used for testing


float xCenter = scale / 2;
float yCenter = scale / 2;

float m = 0; // used to calculate extrapolation points
boolean drawGuides = true;
boolean guidePointNumbers = true;
boolean designPoints = true;

boolean dseignPointNumbers = true;
boolean drawDesign = true;
boolean drawEllipses = false;

boolean InnerCircleDots = false;
boolean InnerCircleText = false;

boolean InnerMostCircleDots = false;
boolean InnerMostCircleText = false;

float x, y; // used to hold intersection point
float a1;
float b1;
float c1;
float a2;
float b2;
float c2;
float det;

int xOffset = 5; // text offset for point lables
int yOffset = 5; // text offset for point lables

void setup() {
  // size(scale,scale)
  size(700, 700);
   smooth();

  background(255);
  noLoop();
}

void draw() {
  translate(50, 50);
  step01(drawDesign); // Outer circle 
  step06(drawDesign); // Inner circle 
  step07(drawDesign); // Inner Most circle 
  step08(drawDesign); // Extend the stide of the squares in step06 & step07 to the outer hexagon 
  step09(drawDesign, drawEllipses);
  
  designPoints(0, 0, 0, dseignPointNumbers);  // text colour for design points
  guidePoints(0, 0, 0, guidePointNumbers, true);  //  text colour for guide points
  
  // save("Qarawiyyn_Mosque_019.png");
}

float extrapolateY(float x1, float y1, float x2, float y2, float x) {
  m = (y2 - y1) / (x2 - x1);
  return y1 + m * (x - x1);
}


float extrapolateX(float x1, float y1, float x2, float y2, float y) {
  m = (y2 - y1) / (x2 - x1);
  return x1 + ((y - y1) * (x2 - x1)) / (y2 - y1);
}
